# I25 — Tie-Kernel Primitivity & RNG Determinism (PASS repo)

This repository reproduces the **PASS** configuration of the I25 simulation.

## Contents
- `engine_i25_kernel_rng.py` — Simulation engine (stdlib only; present-act; RNG at ties only).
- `config/manifest_i25.json` — **PASS** manifest (H=48000, tie_every=3, l1_tol=0.02).
- `run.py` — Programmatic runner (recommended).
- `run.sh`, `run.bat` — Convenience wrappers.
- `sample_outputs/expected_result_line.txt` — Result line from a PASS run for reference.

## Requirements
- Python 3.9+ (no third-party packages required).

## Quickstart
```bash
python3 run.py
```
This will create a timestamped workspace at:
```
I25_kernel_rng/<UTC_timestamp>/
  ├─ config/
  ├─ outputs/
  │   ├─ metrics/
  │   ├─ audits/
  │   └─ run_info/
  └─ logs/
```

## Notes
- Randomness is used **only at exact ties**. All other decisions are deterministic.
- The included manifest uses **H=48000** to comfortably satisfy the Born L1 tolerance (0.02).
- If you change the tolerance τ, use the sizing rule: `H / tie_every ≥ ⌈1.5·k / τ²⌉` with `k = len(labels)`.

## Alternative CLI
A CLI entry point exists in `engine_i25_kernel_rng.py`, but `run.py` is recommended because it handles workspace setup via engine helpers.